# The Rust Ecosystem

The `rustc` compiler is at heart of the Rust Ecosystem. Other tools of great help for your developments include (clickable references)

* [rustup](https://www.rustup.rs/), Rust tool-chain manager [Rustup](#Rustup)
* [cargo](https://crates.io/), build system and package/crate manager 
* [cargo-update](https://crates.io/crates/cargo-update), cargo sub-command to manage crate updates 
* [xargo](https://crates.io/crates/xargo) Systoot manager to build for non-`std` targets

The Rust ecosystem also provides support to program development, in terms of external `crates` for code completion formatting and formatting
* [racer](https://crates.io/crates/racer/), Code completion for Rustbuild system and package/crate manager 
* [rustfmt](https://crates.io/crates/rustfmt), Tool to find and fix Rust formatting issues 
* [rls-preview](https://github.com/rust-lang-nursery/rls), Rust Language Server (RLS). RLS is a server that runs in the background, providing IDEs, editors, and other tools with information about Rust programs. The `rls-preview` is in alpha state, meaning that it's not guaranteed to compile/work. (You may check under build/passing, the latest changes that passed compilation.)

Rust support for various IDEs and editors 
* [rls](https://marketplace.visualstudio.com/items?itemName=rust-lang.rust), Rust support for Visual Studio Code, based on the `rls-preview`. This is the reference implementation for `rls` support (currently in alpha/preview state).
* [rustdt](http://rustdt.github.io/), Rust support for the Eclipse platform (currently not further maintained)
* Atom, Sublime, Code::Blocks support is also available

Other tools that come in handy for embedded development
* [itm](https://crates.io/crates/itm) Tool to parse and dump ITM packets
* add here your favorite tools supporting Rust development

# Installation

We suggest a Linux or OSX development environment, though Rust related tools are also available on Windows. Install  [rustup](https://www.rustup.rs/), Rust tool-chain manager using the link, and go from there.

# Rustup

The [rustup](https://www.rustup.rs/), tool manager allows you to manage multiple tool chain installations. Rust is distributed in three channels (`stable`, `beta` and `nightly`). You may set the default toolchain:
```
rustup default nightly-2017-10-22-x86_64-unknown-linux-gnu 
```
and get information on the status of `rustup`
```
rustup show
```

Nightly tool chains allow for the development of libraries and applications including `unsafe` code using features not available on the `stable channel` (which will be necessary for the later exercises). For some tools to work (`rls/rustfmt`), you need to install additional components. For this to work, you should use a nightly toolchain for which all tools and components work (currently `nightly-2017-10-30` is the latest). Here is an example:
```
rustup default nightly-2017-10-30
rustup component add rls-preview
rustup component add rust-analysis
rustup component add rust-src
```
`rls-preview`, `rust-analysis` and `rust-src` are required for RLS support (including cross-referencing to the standard library, code completion and formatting).

# Cargo

Cargo is the go-to tool for managing Rust application and your own Rust developments (see [cargo](https://crates.io/) for detailed documentation). 

By default your Rust related tools will be stored in `~/.cargo`, this directory should be added to your `$PATH` environment. `cargo` and `rustup` works closely together, e.g., you may tell `cargo` to use a specific toolchain for the build. 

In order to get formatting to work you need to install `rustfmt-nightly`.
```
cargo install rustfmt-nightly
```
There is also another (old) crate named `rustfmt`, that can be compiled with the `stable` Rust compiler. The `rustfmt-nightly` is the *new* and improved formatter, that will eventually replace the old stable `rustfmt` (the generated binaries have the same name so do *not* install the stable version).

# Rust Crates

A *crate* is a unit of compilation, being either a *library* or an executable *application* (binary). Crates are managed (compiled, installed, removed, updated, etc.) by the [cargo](https://crates.io/) tool. 

`*.toml` files are used throughout Rust developments for giving configuration (meta) information (essentially replacing the need of Makefiles). The `Cargo.lock` file shows the cashed dependencies (you may delete the `Cargo.lock` file to force updating dependencies, `cargo clean` may not be enough).

Dependencies (may) include a minimal version, following the [semver](http://semver.org/) versioning standard.

# VSCODE support
## RLS 
[vscode](https://wiki.archlinux.org/index.php/Visual_Studio_Code) is the official integration test platform for the RLS development, and hence likely also to provide the best user experience. 

See [rls](https://marketplace.visualstudio.com/items?itemName=rust-lang.rust) for installing the RLS extension.

You will need to pin the specific toolchain version used, by setting the `"rust-client.channel": "nightly-2017-10-30"` in your `vscode` *user* settings (this will be stored in a file `~/.config/Code/User/settings.json` and used for all your `vscode` projects. Settings may be set individually for each *workspace*, overriding the defaults. Regarding the  `"rust-client.channel"` setting, a *workspace* setting would force the specific version (overriding the default), and may not work when the code is distributed (as other developers may be on other toolchains).

For RLS to work, `vscode` need a path to the `rls-preview` library (using the environment variable `LD_LIBRARY_PATH` (Linux), `DYLD_LIBRARY_PATH` (OSX ?)). 
```
export LD_LIBRARY_PATH=$(rustc --print sysroot)/lib:$LD_LIBRARY_PATH
```
You may add this to your `~/.bash_profile`, and start vscode (`code` is the name of the executable) in a new terminal (to ensure that the `LD_LIBRARY_PATH` (Linux) `DYLD_LIBRARY_PATH` (OSX?) is correctly set). If `code` is run from your window manager (e.g., `plasma`), make sure that the environment is set correctly. 

Under the hood: `rustc --print sysroot` gives you the path to the root of the current toolchain. So its important that the toolchain is set correctly by `rustup` for this to work. 


## GIT
You may choose to use the [gitlens](https://github.com/eamodio/vscode-gitlens) extension, to get integrated git support.

## Native Debug
The [Native Debug](https://github.com/WebFreak001/code-debug) extension allows for debugging Rust application from within `vscode`. Native Debug supports both `lldb` (LLVM) and `gdb` (GNU)
debuggers. For embedded development, you will use the latter. See Embedded.md (TODO) for further details.
