#![feature(lang_items)]
#![no_std]
#![no_main]

#[panic_handler]
fn my_panic(_info: &core::panic::PanicInfo) -> ! {
    loop {}
}

// The reset vector, a pointer into the reset handler
#[link_section = ".init"]
#[no_mangle]
pub extern "C" fn _start() -> ! {
    extern "C" {
        // These symbols come from `link.x`
        static mut __sbss: u32;
        static mut __ebss: u32;

        static mut __sdata: u32;
        static mut __edata: u32;
        static __sidata: u32;
    }

    extern "Rust" {
        // This symbol will be provided by the user via `#[entry]`
        fn main() -> !;

    }

    // Initialize RAM
    // r0::zero_bss(&mut __sbss, &mut __ebss);
    // r0::init_data(&mut __sdata, &mut __edata, &__sidata);

    unsafe { main() }
    loop {}
}

#[lang = "eh_personality"]
extern "C" fn eh_personality() {}
