#![no_std]
#![no_main]

// #![feature(const_generics)]
// fn rev<const X: usize>(from: &[u8; X], to: &mut [u8; X]) {
//     if from.len() > 0 {}
// }

extern crate mips_rt;

fn rev(from: &[u8], to: &mut [u8]) {
    let len = from.len();
    if len > 0 {
        rev(&from[1..], &mut to[..len - 1]);
        to[len - 1] = from[0];
    }
}

const FROM: &[u8] = b"Hello Word!";
const SIZE: usize = FROM.len();

#[no_mangle]
fn main() {
    let mut to: [u8; SIZE] = [0; SIZE];
    rev(&FROM[..], &mut to);
    unsafe {
        core::ptr::read_volatile(&to);
    }
}
