#![deny(unsafe_code)]
// #![deny(warnings)]
#![no_main]
#![no_std]

use async_cortex_m::{task, unsync::Mutex};
use cortex_m_semihosting::{debug, hprintln};
use panic_halt as _; // panic handler
use rtic::app;

#[rtic::app(device = lm3s6965)]
mod app {
    #[resources]
    struct Resources {
        #[init(9)]
        x: u32,
    }

    #[idle(resources = [x])]
    fn idle(mut cx: idle::Context) -> ! {
        static mut X: Mutex<i64> = Mutex::new(0);
        let c: &'static _ = X;

        cx.resources.x.lock(|x| {
            hprintln!("x {}", x).ok();
        });

        task::spawn(a1(c));

        task::block_on(async {
            loop {
                hprintln!("B: before lock").ok();

                // cannot immediately make progress; context switch to A
                let mut lock = c.lock().await;

                hprintln!("B: {}", *lock).ok();
                *lock += 1;

                if *lock > 3 {
                    debug::exit(debug::EXIT_SUCCESS);
                } else {
                    drop(lock);
                    hprintln!("B: yield").ok();
                    task::r#yield().await;
                }
            }
        });

        loop {
            continue;
        }
    }
    #[task(binds = UART0, resources = [x])]
    fn rt_task(cx: rt_task::Context) {
        hprintln!("x {}", cx.resources.x).ok();
    }
}

async fn a1(c: &Mutex<i64>) {
    loop {
        hprintln!("A: before lock").ok();

        let mut lock = c.lock().await;

        hprintln!("A: before write {}", *lock).ok();
        *lock += 1;
        drop(lock);

        hprintln!("A: after releasing the lock").ok();

        hprintln!("A: manual yield").ok();
        task::r#yield().await;
    }
}

// fn some_driver() -> impl Future {
//     task::r#yield()
// }
