#![deny(unsafe_code)]
#![deny(warnings)]
#![no_main]
#![no_std]

use async_cortex_m::{task, unsync::Mutex};
use cortex_m::asm;
use cortex_m_rt::entry;
use cortex_m_semihosting::hprintln;
use nrf52 as _; // memory layout
use panic_udf as _; // panic handler

#[entry]
fn main() -> ! {
    static mut X: Mutex<i64> = Mutex::new(0);
    let c: &'static _ = X;
    task::spawn(async move {
        loop {
            hprintln!("A: before lock").ok();

            let mut lock = c.lock().await;

            hprintln!("A: before write {}", *lock).ok();
            *lock += 1;
            drop(lock);

            hprintln!("A: after releasing the lock").ok();

            hprintln!("A: manual yield").ok();
            task::r#yield().await;
        }
    });

    task::block_on(async {
        loop {
            hprintln!("B: before lock").ok();

            // cannot immediately make progress; context switch to A
            let mut lock = c.lock().await;

            hprintln!("B: {}", *lock).ok();
            *lock += 1;

            if *lock > 10 {
                loop {
                    asm::bkpt();
                }
            } else {
                drop(lock);
                hprintln!("B: yield").ok();
                task::r#yield().await;
            }
        }
    });

    loop {
        continue;
    }
}
