#![deny(unsafe_code)]
// #![deny(warnings)]
#![no_main]
#![no_std]

use async_cortex_m::{task, unsync::Mutex};
use cortex_m::asm;
use cortex_m_semihosting::hprintln;
use pac::Interrupt::TIMER0;
use panic_udf as _; // panic handler
use rtfm::app;

#[app(device = pac)]
const APP: () = {
    struct Resources {
        #[init(9)]
        rtfm_x:u64,
    }

    #[idle(resources = [rtfm_x])]
    fn idle(mut cx: idle::Context) -> ! {
        static mut X: Mutex<i64> = Mutex::new(0);
        let c: &'static _ = X;
        // static mut RT_X : impl rtfm::Mutex = &mut cx.resources.x;

        // rt_x.lock(|x| {
        //     hprintln!("x {}", x);
        // });
  
        cx.resources.rtfm_x.lock(|x| {
            hprintln!("x {}", x);
        });

        // let cc:&'static _ = &cx.resources.x;
   
        task::spawn(async {
            loop {
                hprintln!("A: before lock").ok();

                // let mut lock = c.lock().await;

                // hprintln!("A: before write {}", *lock).ok();
                // *lock += 1;
                // drop(lock);

                hprintln!("A: after releasing the lock").ok();

                hprintln!("A: manual yield").ok();
                task::r#yield().await;
                // cc.lock(|x| {
                //     hprintln!("x {}", x);
                // });

                cx.resources.rtfm_x.lock(|x| {
                    hprintln!("x {}", x);
                });
                
            }
        });

        task::block_on(async {
            loop {
                hprintln!("B: before lock").ok();

                // cannot immediately make progress; context switch to A
                let mut lock = c.lock().await;

                hprintln!("B: {}", *lock).ok();
                *lock += 1;


                if *lock > 10 {
                    loop {
                        asm::bkpt();
                    }
                } else {
                    drop(lock);
                    hprintln!("B: yield").ok();
                    task::r#yield().await;
                }

                cx.resources.rtfm_x.lock(|x| {
                    hprintln!("x {}", x);
                });
            }
        });

        loop {
            continue;
        }
    }

    #[task(priority = 2, binds = TIMER0, resources = [rtfm_x])]
    fn rt_task(cx:rt_task::Context) {
        hprintln!("x {}", cx.resources.rtfm_x);
    }
};
