# The Rust Ecosystem

The `rustc` compiler is at heart of the Rust Ecosystem. Other tools of great help for your developments include (clickable references)

* [rustup](https://www.rustup.rs/), Rust tool-chain manager [Rustup](#Rustup)
* [cargo](https://crates.io/), build system and package/crate manager 
* [cargo-update](https://crates.io/crates/cargo-update), cargo sub-command to manage crate updates 
* [xargo](https://crates.io/crates/xargo) Systoot manager to build for non-`std` targets

Various other Rust tools you might find useful
* [rls](https://marketplace.visualstudio.com/items?itemName=rust-lang.rust), Rust support for Visual Studio Code
* [racer](https://crates.io/crates/racer/), Code completion for Rustbuild system and package/crate manager 
* [rustfmt](https://crates.io/crates/rustfmt), Tool to find and fix Rust formatting issues 
* [itm](https://crates.io/crates/itm) Tool to parse and dump ITM packets
* add here your favorite crates


Other tools and packages 
* [rls](https://marketplace.visualstudio.com/items?itemName=rust-lang.rust), Rust support for Visual Studio Code
* [rustdt](http://rustdt.github.io/), Rust support for the Eclipse platform
* add here your favorite tools supproting Rust development

# Installation

We suggest a linux or OSX development environment, though Rust related tools are also available under Windows. Install  [rustup](https://www.rustup.rs/), Rust tool-chain manager using the link, and go from there.

# Rustup

The [rustup](https://www.rustup.rs/), tool manager allows you to manage multiple tool chain installations. Nightly tool chains allow for the development of libraries and applations including `unsafe` code (which will be necessary for the later excercises). For some tools to work (rls/rustfmt) you need to install the Rust sources. By default your Rust related tools will be stored in `~/.rustup`.

# Rust Crates

A crate is a unit of compilation, being either a library or an application. Crates are managed (compiled, installed, removed, updated, etc.) by the [cargo](https://crates.io/) tool. 

`*.toml` files are used throughtout Rust developments for giving configuration (meta) information. The `Cargo.lock` file shows the cashed dependencies (you may delete the `Cargo.lock` file to force updating dependencies, `cargo clean may not be enough).

Dependencies (may) include a minimal version, eg `itm = "0.1.1"` indicates that at least version `0.1.1` in required (so `0.1.1`, `0.1.2`, `0.2.3` is Ok, while `0.1.0` will not suffice, and a version `1.0.0` would be considered a breaking change (major number changed) and not considered. Rust follows the [semver](http://semver.org/) versioning standard.